<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:fn="fn"
    xmlns:pl="http://product-live.com"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    version="3.0"
    exclude-result-prefixes="xs fn pl">
    
    <xsl:output method="xml" indent="yes" encoding="UTF-8" cdata-section-elements="" />
    
    <xsl:template match="/">
        <!-- 
            Usually you will have two variables old and new containing the same type of data
        -->
        <xsl:variable name="old" select="" />
        <xsl:variable name="new" select="" />

        <!-- 
            Then you use the merge function (snippet: mer)
         -->
        <xsl:merge>
            <!-- 
                Reference each source in merge-source
                xsl:merge-source element defines one or more merge input sequences
                Do not forgot sort-before-merge="yes"
             -->
            <xsl:merge-source name="old" select="$old" sort-before-merge="yes">
                <!-- 
                    The merge-key is the attribut or element use to find the same node
                    Use an xpath relative to the merge source
                 -->
                <xsl:merge-key select="xpath-relative-to-$old"/>
            </xsl:merge-source>
            <xsl:merge-source name="new" select="$new" sort-before-merge="yes">
                <xsl:merge-key select="xpath-relative-to-$new"/>
            </xsl:merge-source>
            <!-- 
                Merge action 
             -->
            <xsl:merge-action>
                <!-- 
                    If you need it you can distinguish all cases
                 -->
                <xsl:when test="current-merge-group('old') and current-merge-group('new')">
                
                </xsl:when>
                <xsl:when test="current-merge-group('old') and not(current-merge-group('new'))">
                
                </xsl:when>
                <xsl:when test="not(current-merge-group('old')) and current-merge-group('new')">
                
                </xsl:when>
            </xsl:merge-action>
        </xsl:merge>
    </xsl:template>
</xsl:stylesheet>